﻿using System;
using NCMS.Utils;
using UnityEngine;
using UnityEngine.Events;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Reflection;
using ReflectionUtility;

namespace Diplomacy_Army
{
	class ArmyPowerWindow
	{
		public static string name = "ArmyControlWindow";
		public static PowerButton powerButton;

		private static ScrollWindow window;
		private static GameObject content;
		private static GodPower power;
		private static int index = 0;

		// Initializing Tiles Window
		internal static PowerButtonSelector pbsInstance;
		public static void init()
		{
			// Creating new window
			window = Windows.CreateNewWindow(name, "Select Tile");

			// Activating Scroll View object
			var scrollView = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View");
			scrollView.gameObject.SetActive(true);


			// Fixing size to fit
			var viewport = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View/Viewport");
			var viewportRect = viewport.GetComponent<RectTransform>();
			viewportRect.sizeDelta = new Vector2(0, 17);

			// Getting Content object
			content = GameObject.Find($"/Canvas Container Main/Canvas - Windows/windows/{window.name}/Background/Scroll View/Viewport/Content");

			// Getting power button selector using reflections with ReflectionUtility
			pbsInstance = Reflection.GetField(typeof(PowerButtonSelector), null, "instance") as PowerButtonSelector;

			initArmyGodpower();
		}

		private static void initArmyGodpower()
		{
			createTileButton(index++, content.transform, "集中进攻", "inspiration", "所有军队前往指定城市", new UnityAction(tryToHideWindow));
			createTileButton(index++, content.transform, "局部进攻", "inspiration", "指定一座城市的军队前往另一个城市", new UnityAction(tryToHideWindow2));
			createTileButton(index++, content.transform, "回防", "inspiration", "所有军队前往驻地城市", new UnityAction(tryToHideWindow3));
			createTileButton(index++, content.transform, "总动员", "inspiration", "全国1/3成年人口获得青铜矛+皮革，并转职成战斗人员", new UnityAction(tryToHideWindow4));
			createTileButton(index++, content.transform, "局部动员", "inspiration", "指定城市2/3成年人口获得青铜矛+皮革，并转职成战斗人员", new UnityAction(tryToHideWindow5));

		}

		private static void createTileButton(int index, Transform pParent, string powerID, string pSprite, string pDescription, UnityAction pCall = null)
		{
			GodPower godPower = new GodPower();
			godPower.id = powerID;
			godPower.name = powerID;
			godPower.unselectWhenWindow = true;
			AssetManager.powers.add(godPower);
			NewFunction.CreateNewButtonOnWindow(NewFunction.getPositionByIndex(index), pParent, pSprite, godPower, pDescription, pCall, PowerButtonType.Active);
		}


		public static bool tryToAttack_Kingdom(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			if (MoreGodPower.selected_kingdom == null)
			{
				var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
				MoreGodPower.selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要发动一次集中进攻......");
			}
			else
			{
				foreach (City city in MoreGodPower.selected_kingdom.cities)
				{
					if (city.army != null && city.army.countUnits() > 0)
					{
						NewFunction.MoveArmy(city.army, pTile.zone.city.getTile());
						NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, "国家", "发动了一次集中进攻......");
					}
				}
				MoreGodPower.selected_kingdom = null;
			}
			return true;
		}
		public static bool tryToAttack_City(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			if (MoreGodPower.selected_city == null)
			{
				var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
				MoreGodPower.selected_city = pTile.zone.city;
				MoreGodPower.selected_kingdom = kingdom;
				NewFunction.LogNewMessage(kingdom, "国家", "想要发动一次局部进攻......");
			}
			else
			{
				if (MoreGodPower.selected_city.army != null && MoreGodPower.selected_city.army.countUnits() > 0)
				{
					NewFunction.MoveArmy(MoreGodPower.selected_city.army, pTile.zone.city.getTile());
					NewFunction.LogNewMessage(MoreGodPower.selected_kingdom, "国家", "发动了一次集中进攻......");
				}
				MoreGodPower.selected_city = null;
				MoreGodPower.selected_kingdom = null;
			}
			return true;
		}
		public static bool tryToCallBackArmy(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			foreach (City city in kingdom.cities)
			{
				if (city.army != null && city.army.countUnits() > 0)
				{
					NewFunction.MoveArmy(city.army, city.getTile());
				}
			}
			NewFunction.LogNewMessage(kingdom, "国家", "全军撤退");
			return true;
		}
		public static bool tryToMobilize_kingdom(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			var kingdom = Reflection.GetField(pTile.zone.city.GetType(), pTile.zone.city, "kingdom") as Kingdom;
			ItemAsset wItemAsset = AssetManager.items.get("spear");
			ItemAsset aItemAsset = AssetManager.items.get("armor");
			string wMaterial = "bronze";
			string aMaterial = "leather";
			foreach (City city in kingdom.cities)
			{
				int num = city.professionsDict[UnitProfession.Unit].Count / 2;
				if (num > 0)
				{
					foreach (Actor actor in city.professionsDict[UnitProfession.Unit])
					{
						actor.CallMethod("setProfession", UnitProfession.Warrior);
						((AiSystemActor)Reflection.GetField(actor.GetType(), actor, "ai")).setJob("attacker");
						ItemData item = ItemGenerator.generateItem(wItemAsset, wMaterial, MapBox.instance.mapStats.year - 10, null, null, 1, actor);
						item.modifiers.Clear();
						actor.equipment.getSlot(wItemAsset.equipmentType).CallMethod("setItem", item);

						item = ItemGenerator.generateItem(aItemAsset, aMaterial, MapBox.instance.mapStats.year - 10, null, null, 1, actor);
						item.modifiers.Clear();
						actor.equipment.getSlot(aItemAsset.equipmentType).CallMethod("setItem", item);
						num--;
						if (num <= 0)
						{
							break;
						}
					}
				}
			}
			NewFunction.LogNewMessage(kingdom, "国家", "动员完毕");
			return true;
		}
		public static bool tryToMobilize_city(WorldTile pTile, string pPower)
		{
			if (pTile.zone.city == null)
			{
				return false;
			}
			City city = pTile.zone.city;
			var kingdom = Reflection.GetField(city.GetType(), city, "kingdom") as Kingdom;
			string name = (Reflection.GetField(city.GetType(), city, "data") as CityData).cityName;
			ItemAsset wItemAsset = AssetManager.items.get("spear");
			ItemAsset aItemAsset = AssetManager.items.get("armor");
			string wMaterial = "bronze";
			string aMaterial = "leather";
			int num = city.professionsDict[UnitProfession.Unit].Count / 2;
			if (num > 0)
			{
				foreach (Actor actor in city.professionsDict[UnitProfession.Unit])
				{
					actor.CallMethod("setProfession", UnitProfession.Warrior);
					((AiSystemActor)Reflection.GetField(actor.GetType(), actor, "ai")).setJob("attacker");
					ItemData item = ItemGenerator.generateItem(wItemAsset, wMaterial, MapBox.instance.mapStats.year - 10, null, null, 1, actor);
					item.modifiers.Clear();
					actor.equipment.getSlot(wItemAsset.equipmentType).CallMethod("setItem", item);

					item = ItemGenerator.generateItem(aItemAsset, aMaterial, MapBox.instance.mapStats.year - 10, null, null, 1, actor);
					item.modifiers.Clear();
					actor.equipment.getSlot(aItemAsset.equipmentType).CallMethod("setItem", item);
					num--;
					if (num <= 0)
					{
						break;
					}
				}
			}
			NewFunction.LogNewMessage(kingdom, "国家", "的" + name + "动员完毕");
			return true;
		}



		public static void tryToHideWindow()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToAttack_Kingdom));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}
		public static void tryToHideWindow2()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToAttack_City));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}
		public static void tryToHideWindow3()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToCallBackArmy));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}
		public static void tryToHideWindow4()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToMobilize_kingdom));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}
		public static void tryToHideWindow5()
		{
			power = Reflection.GetField(powerButton.GetType(), powerButton, "godPower") as GodPower;
			power.click_action = null;
			power.click_action = (PowerActionWithID)Delegate.Combine(power.click_action, new PowerActionWithID(tryToMobilize_city));
			ScrollWindow.get(name).clickHide();
			pbsInstance.clickPowerButton(powerButton);
		}
	}
}
